function [y_max,cutoff_choice] = Mannings_cutoff(units,figure_counter,new_geo)
%A function to determine if the user wants to analyze the entire cross
% sectional geometry of the riffle or pool for the Manning's Equation, 
% simply stop at a depth, or have the program automatically vertically
% exprapolate the data.

figure(figure_counter)
plot(new_geo(:,1),new_geo(:,2),'g')
title('Cross Sectional Geometry')
if units == 1
    ylabel('Y distance (meters)')
    xlabel('X distance (meters)')
else
    ylabel('Y distance (feet)')
    xlabel('X distance (feet)')
end

disp(' ')
fprintf('Based on the cross sectional geometry you have entered shown in Figure %0.0f,\n',figure_counter)
fprintf('\twould you like to: ')
disp(' ')
disp('1. Stop the at-a-stage calculations at a height I prescribe.')
disp('2. Stop the at-a-stage calculations at an automatic height.')
disp('     (only analyzes stages with data present at each bank)')
disp('3. Stop the at-a-stage calculations at the highest elevation.')
disp('     (if data is missing at one bank, the program assumes it is straight)')
disp(' ')

cutoff_choice = 0;

while (cutoff_choice ~= 1 && cutoff_choice ~= 2 && cutoff_choice ~= 3)
    
    cutoff_choice = input('Please enter your choice, 1 through 3:  ');
    
    if (cutoff_choice ~= 1 && cutoff_choice ~= 2 && cutoff_choice ~= 3)
        disp(' ')
        disp('Please enter either 1, 2, or 3.')
        disp(' ')
    end %of if statement
    
end %of while

%% User specified maximum height
if cutoff_choice == 1

    y_max = 0;

    while y_max <= 0
        
        disp(' ')
        if units == 1
            y_max = input('Please enter the maximum at-a-stage calculation height (in meters):  ');
        else
            y_max = input('Please enter the maximum at-a-stage calculation height (in feet):  ');
        end

        if y_max <= 0
            disp(' ')
            disp('Please enter a positive number.')
            disp(' ')            
        end %of if
        
        if y_max > max(new_geo(:,2))
            disp(' ')
            if units == 1
                fprintf('Please enter a number less than or equal to %0.4f meters, the highest elevation.',...
                    max(new_geo(:,2)))
            else
                fprintf('Please enter a number less than or equal to %0.4f feet, the highest elevation.',...
                    max(new_geo(:,2)))
            end
            disp(' ')           
            
            y_max = 0;            
        end %of if
        
    end %of while

end %of if

%% Automatic stopping height
if cutoff_choice == 2    
    maxs(1) = max(new_geo(1:floor(end/2),2));
    maxs(2) = max(new_geo(floor(end/2)+1:end,2));
    
    y_max = min(maxs);
end

%% Vertical Extrapolation
if cutoff_choice == 3
    y_max = max(new_geo(:,2));
end